<?php
/**
 * Configuration File
 * Contains all database and application settings
 */

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'ai_app_generator');
define('DB_USER', 'your_db_username');
define('DB_PASS', 'your_db_password');
define('DB_CHARSET', 'utf8mb4');

// Application Settings
define('APP_NAME', 'AI App Generator');
define('APP_VERSION', '1.0.0');
define('APP_URL', 'https://yourdomain.com');
define('APP_DIR', __DIR__);

// Security Settings
define('ENCRYPTION_KEY', 'your-32-character-encryption-key-here');
define('SESSION_TIMEOUT', 3600); // 1 hour
define('MAX_UPLOAD_SIZE', 50 * 1024 * 1024); // 50MB

// AI API Configuration
define('OPENAI_API_KEY', ''); // Set your OpenAI API key
define('CLAUDE_API_KEY', ''); // Set your Claude API key
define('DEFAULT_AI_PROVIDER', 'openai');

// File Upload Settings
define('UPLOAD_DIR', APP_DIR . '/uploads/');
define('PROJECTS_DIR', APP_DIR . '/projects/');
define('TEMPLATES_DIR', APP_DIR . '/templates/');

// Email Settings
define('SMTP_HOST', 'your-smtp-host');
define('SMTP_PORT', 587);
define('SMTP_USER', 'your-email@domain.com');
define('SMTP_PASS', 'your-email-password');
define('FROM_EMAIL', 'noreply@yourdomain.com');
define('FROM_NAME', APP_NAME);

// Development Mode
define('DEBUG_MODE', true); // Set to false in production

// Timezone
date_default_timezone_set('UTC');

// Error reporting
if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Create necessary directories
if (!is_dir(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}
if (!is_dir(PROJECTS_DIR)) {
    mkdir(PROJECTS_DIR, 0755, true);
}
if (!is_dir(TEMPLATES_DIR)) {
    mkdir(TEMPLATES_DIR, 0755, true);
}
?>