-- AI App Generator Database Schema
-- Generated for shared hosting MySQL/MariaDB

-- Users table for admin accounts
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `role` enum('admin','user') DEFAULT 'user',
  `is_active` tinyint(1) DEFAULT 1,
  `last_login` timestamp NULL DEFAULT NULL,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Projects table for generated applications
CREATE TABLE IF NOT EXISTS `projects` (
  `id` varchar(50) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text,
  `app_type` varchar(50) DEFAULT 'web',
  `prompt` text,
  `generated_files` longtext,
  `status` enum('draft','generating','complete','error') DEFAULT 'draft',
  `is_public` tinyint(1) DEFAULT 0,
  `view_count` int(11) DEFAULT 0,
  `file_size` bigint(20) DEFAULT 0,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Project files for tracking generated files
CREATE TABLE IF NOT EXISTS `project_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `project_id` varchar(50) NOT NULL,
  `file_path` varchar(500) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_type` varchar(50) DEFAULT NULL,
  `file_size` bigint(20) DEFAULT 0,
  `content` longtext,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `project_id` (`project_id`),
  KEY `file_name` (`file_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Templates for pre-built app types
CREATE TABLE IF NOT EXISTS `templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `category` varchar(50) DEFAULT NULL,
  `description` text,
  `prompt_template` text,
  `icon` varchar(100) DEFAULT NULL,
  `preview_image` varchar(255) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `sort_order` int(11) DEFAULT 0,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `category` (`category`),
  KEY `is_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- AI generation logs for debugging
CREATE TABLE IF NOT EXISTS `generation_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `project_id` varchar(50) DEFAULT NULL,
  `prompt` text,
  `provider` varchar(50) DEFAULT NULL,
  `request_data` longtext,
  `response_data` longtext,
  `status` enum('success','error','pending') DEFAULT 'pending',
  `error_message` text,
  `processing_time` float DEFAULT NULL,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `project_id` (`project_id`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Settings table for application configuration
CREATE TABLE IF NOT EXISTS `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(100) NOT NULL,
  `value` longtext,
  `type` enum('string','integer','boolean','json') DEFAULT 'string',
  `description` varchar(255) DEFAULT NULL,
  `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Sessions table for user management
CREATE TABLE IF NOT EXISTS `sessions` (
  `id` varchar(128) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `data` longtext,
  `last_activity` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `last_activity` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert default templates
INSERT INTO `templates` (`name`, `category`, `description`, `prompt_template`, `icon`, `sort_order`) VALUES
('E-commerce Store', 'business', 'Online store with product catalog, shopping cart, and checkout', 'Create a complete e-commerce store with product catalog, shopping cart, and checkout functionality', 'fas fa-shopping-cart', 1),
('Blog Website', 'content', 'Personal or business blog with post management', 'Build a modern blog website with post management, categories, and comments', 'fas fa-blog', 2),
('Portfolio Website', 'creative', 'Showcase your work and projects', 'Create a professional portfolio website to showcase your projects and work', 'fas fa-briefcase', 3),
('Business Website', 'business', 'Company website with services and contact', 'Build a business website with services, about, and contact pages', 'fas fa-building', 4),
('Dashboard Application', 'business', 'Admin dashboard with data visualization', 'Create an admin dashboard with charts, tables, and user management', 'fas fa-chart-line', 5),
('Landing Page', 'marketing', 'Marketing landing page with call-to-action', 'Build a compelling landing page for marketing or product promotion', 'fas fa-megaphone', 6),
('Restaurant Website', 'business', 'Restaurant website with menu and reservations', 'Create a restaurant website with menu, location, and reservation system', 'fas fa-utensils', 7),
('Personal Website', 'personal', 'Simple personal website with bio and links', 'Build a personal website with bio, about, and social links', 'fas fa-user', 8);

-- Insert default settings
INSERT INTO `settings` (`key`, `value`, `type`, `description`) VALUES
('site_name', 'AI App Generator', 'string', 'Name of the application'),
('site_description', 'Create web applications using artificial intelligence', 'string', 'Short description of the application'),
('max_projects_per_user', '50', 'integer', 'Maximum number of projects per user'),
('allowed_file_types', 'html,css,js,php,json,md,txt', 'string', 'Allowed file types for upload'),
('ai_max_tokens', '4000', 'integer', 'Maximum tokens for AI generation'),
('ai_temperature', '0.7', 'integer', 'AI generation temperature (0-1)'),
('require_registration', '0', 'boolean', 'Whether registration is required'),
('enable_public_projects', '1', 'boolean', 'Whether to allow public project sharing'),
('maintenance_mode', '0', 'boolean', 'Whether the site is in maintenance mode');

-- Add foreign key constraints
ALTER TABLE `projects` ADD CONSTRAINT `projects_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;
ALTER TABLE `project_files` ADD CONSTRAINT `project_files_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE;
ALTER TABLE `generation_logs` ADD CONSTRAINT `generation_logs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;
ALTER TABLE `generation_logs` ADD CONSTRAINT `generation_logs_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE;
ALTER TABLE `sessions` ADD CONSTRAINT `sessions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;