<?php
// Installation Complete Step
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Mark installation as complete
    file_put_contents(__DIR__ . '/../config/.installed', date('Y-m-d H:i:s'));
    
    // Clean up session data
    unset($_SESSION['install_db']);
    unset($_SESSION['install_admin']);
    
    // Redirect to main app
    header('Location: ../index.php?page=dashboard');
    exit;
}

$admin_info = $_SESSION['install_admin'] ?? [];
?>
<h2><i class="fas fa-check-circle" style="color: #10B981;"></i> Installation Complete!</h2>
<p>Congratulations! AI App Generator has been successfully installed and configured.</p>

<div class="alert alert-success">
    <h4><i class="fas fa-rocket"></i> What's Next?</h4>
    <p>Your AI App Generator is now ready to use! You can start creating amazing web applications using artificial intelligence.</p>
</div>

<div style="background: #F8FAFC; padding: 2rem; border-radius: 12px; margin: 2rem 0;">
    <h3><i class="fas fa-tasks"></i> Quick Start Guide</h3>
    <ol style="text-align: left; line-height: 1.8;">
        <li><strong>Login to your admin panel:</strong> Go to your application URL and log in</li>
        <li><strong>Create your first app:</strong> Click "Create New App" and describe what you want to build</li>
        <li><strong>Customize and export:</strong> Edit your generated app and download it for deployment</li>
        <li><strong>Deploy to your hosting:</strong> Upload the exported files to any web hosting service</li>
    </ol>
</div>

<div style="background: #F8FAFC; padding: 2rem; border-radius: 12px; margin: 2rem 0;">
    <h3><i class="fas fa-info-circle"></i> Your Installation Details</h3>
    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem;">
        <div>
            <strong>Site Name:</strong><br>
            <?php echo htmlspecialchars($admin_info['site_name'] ?? 'AI App Generator'); ?>
        </div>
        <div>
            <strong>Admin Email:</strong><br>
            <?php echo htmlspecialchars($admin_info['email'] ?? 'Not configured'); ?>
        </div>
        <div>
            <strong>Application URL:</strong><br>
            <a href="<?php echo htmlspecialchars($admin_info['app_url'] ?? ''); ?>" target="_blank">
                <?php echo htmlspecialchars($admin_info['app_url'] ?? ''); ?>
            </a>
        </div>
    </div>
</div>

<div class="alert alert-info">
    <h4><i class="fas fa-download"></i> Important Files Created</h4>
    <ul style="margin-top: 0.5rem; text-align: left;">
        <li>• <code>config/config.php</code> - Application configuration</li>
        <li>• <code>config/.installed</code> - Installation marker</li>
        <li>• Database tables - All required tables created</li>
        <li>• Admin user account - Ready to login</li>
    </ul>
</div>

<form method="POST" style="margin-top: 2rem;">
    <div class="btn-group" style="justify-content: center;">
        <button type="submit" class="btn btn-primary" style="padding: 1rem 2rem; font-size: 1.1rem;">
            <i class="fas fa-arrow-right"></i> Launch AI App Generator
        </button>
    </div>
</form>

<div style="margin-top: 3rem; padding: 1.5rem; background: #DBEAFE; border-radius: 8px; text-align: center;">
    <h4><i class="fas fa-heart" style="color: #3B82F6;"></i> Thank You!</h4>
    <p>Thank you for choosing AI App Generator. We hope it helps you create amazing web applications with ease!</p>
    <p style="margin-top: 1rem; font-size: 0.9rem; color: #6B7280;">
        If you need help, please refer to the documentation or contact support.
    </p>
</div>