<?php
// Requirements Check Step
$requirements = [
    'PHP Version' => version_compare(PHP_VERSION, '7.4.0', '>='),
    'MySQL Extension' => extension_loaded('mysqli'),
    'PDO MySQL' => extension_loaded('pdo_mysql'),
    'JSON Extension' => extension_loaded('json'),
    'CURL Extension' => extension_loaded('curl'),
    'GD Extension' => extension_loaded('gd'),
    'ZIP Extension' => extension_loaded('zip'),
    'File Permissions' => is_writable(__DIR__ . '/../config/'),
    'Write Permissions' => is_writable(__DIR__ . '/../'),
    'Memory Limit' => (int)ini_get('memory_limit') >= 128
];

$all_passed = true;
$failed_count = 0;

foreach ($requirements as $name => $passed) {
    if (!$passed) {
        $all_passed = false;
        $failed_count++;
    }
}
?>
<h2>System Requirements Check</h2>
<p>We're checking if your server meets the minimum requirements to run AI App Generator.</p>

<div class="alert alert-info">
    <i class="fas fa-info-circle"></i>
    <strong>Note:</strong> Most shared hosting providers meet these requirements. If any items fail, please contact your hosting provider.
</div>

<ul class="requirements">
    <?php foreach ($requirements as $name => $passed): ?>
        <li>
            <span class="<?php echo $passed ? 'check' : 'cross'; ?>">
                <i class="fas fa-<?php echo $passed ? 'check' : 'times'; ?>"></i>
            </span>
            <strong><?php echo $name; ?>:</strong>
            <span style="color: <?php echo $passed ? '#10B981' : '#EF4444'; ?>">
                <?php echo $passed ? 'PASS' : 'FAIL'; ?>
            </span>
        </li>
    <?php endforeach; ?>
</ul>

<?php if (!$all_passed): ?>
    <div class="alert alert-error">
        <h4><i class="fas fa-exclamation-triangle"></i> Requirements Not Met</h4>
        <p>Your server does not meet the minimum requirements. Please contact your hosting provider to upgrade your PHP version or enable the missing extensions.</p>
        
        <h5>Common Solutions:</h5>
        <ul style="margin-top: 1rem;">
            <li>• <strong>PHP Version:</strong> Upgrade to PHP 7.4 or higher in your hosting control panel</li>
            <li>• <strong>MySQL Extensions:</strong> Enable mysqli and pdo_mysql in PHP settings</li>
            <li>• <strong>File Permissions:</strong> Set folder permissions to 755 in your hosting control panel</li>
            <li>• <strong>Memory Limit:</strong> Increase PHP memory limit to 128MB or higher</li>
        </ul>
    </div>
    
    <div class="btn-group">
        <a href="?step=1" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back
        </a>
        <button type="button" class="btn btn-primary" onclick="window.location.reload()">
            <i class="fas fa-sync"></i> Recheck
        </button>
    </div>
<?php else: ?>
    <div class="alert alert-success">
        <h4><i class="fas fa-check-circle"></i> All Requirements Met!</h4>
        <p>Your server is ready for AI App Generator installation. You can proceed to the next step.</p>
    </div>
    
    <div class="btn-group">
        <a href="?step=1" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back
        </a>
        <a href="?step=3" class="btn btn-primary">
            <i class="fas fa-arrow-right"></i> Next: Database Setup
        </a>
    </div>
<?php endif; ?>

<div style="margin-top: 2rem; padding: 1rem; background: #F8FAFC; border-radius: 8px; font-size: 0.9rem;">
    <h5><i class="fas fa-server"></i> Your Server Information:</h5>
    <p><strong>PHP Version:</strong> <?php echo PHP_VERSION; ?></p>
    <p><strong>Server:</strong> <?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown'; ?></p>
    <p><strong>Memory Limit:</strong> <?php echo ini_get('memory_limit'); ?></p>
    <p><strong>Upload Max Size:</strong> <?php echo ini_get('upload_max_filesize'); ?></p>
</div>