<?php
/**
 * Home Page
 * Landing page for the application
 */

include 'includes/header.php';
?>
<div class="home">
    <div class="hero">
        <div class="container">
            <div class="hero-content">
                <h1><i class="fas fa-magic"></i> Create Amazing Apps with AI</h1>
                <p>Transform your ideas into fully functional web applications using the power of artificial intelligence. No coding required.</p>
                <div class="hero-actions">
                    <a href="auth/login.php" class="btn btn-primary btn-lg">
                        <i class="fas fa-rocket"></i> Get Started
                    </a>
                    <a href="?page=templates" class="btn btn-secondary btn-lg">
                        <i class="fas fa-eye"></i> View Templates
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="features">
        <div class="container">
            <div class="section-header">
                <h2>Why Choose AI App Generator?</h2>
                <p>Build professional web applications in minutes, not months</p>
            </div>
            
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-robot"></i>
                    </div>
                    <h3>AI-Powered Generation</h3>
                    <p>Simply describe your app idea and our AI will create a complete, functional web application with all the features you need.</p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <h3>Responsive Design</h3>
                    <p>All generated applications are mobile-first and work perfectly on every device and screen size.</p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-download"></i>
                    </div>
                    <h3>Easy Deployment</h3>
                    <p>Download your completed app as a ZIP file and deploy it to any hosting provider instantly.</p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-layer-group"></i>
                    </div>
                    <h3>Multiple App Types</h3>
                    <p>Create e-commerce stores, blogs, portfolios, dashboards, business websites, and more.</p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-code"></i>
                    </div>
                    <h3>Clean Code</h3>
                    <p>Get well-structured, commented, and maintainable HTML, CSS, and JavaScript code.</p>
                </div>
                
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-bolt"></i>
                    </div>
                    <h3>Lightning Fast</h3>
                    <p>Generate complete applications in minutes, not hours or days of traditional development.</p>
                </div>
            </div>
        </div>
    </div>

    <div class="how-it-works">
        <div class="container">
            <div class="section-header">
                <h2>How It Works</h2>
                <p>From idea to deployed app in four simple steps</p>
            </div>
            
            <div class="steps">
                <div class="step">
                    <div class="step-number">1</div>
                    <div class="step-content">
                        <h3>Describe Your App</h3>
                        <p>Tell our AI what you want to build. Be specific about features, design, and functionality.</p>
                    </div>
                </div>
                
                <div class="step">
                    <div class="step-number">2</div>
                    <div class="step-content">
                        <h3>AI Generation</h3>
                        <p>Our AI analyzes your requirements and generates a complete web application with all necessary files.</p>
                    </div>
                </div>
                
                <div class="step">
                    <div class="step-number">3</div>
                    <div class="step-content">
                        <h3>Review & Customize</h3>
                        <p>Preview your generated app, make any customizations, and ensure it meets your needs.</p>
                    </div>
                </div>
                
                <div class="step">
                    <div class="step-number">4</div>
                    <div class="step-content">
                        <h3>Deploy & Launch</h3>
                        <p>Download your app and deploy it to any hosting provider to go live immediately.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="templates-preview">
        <div class="container">
            <div class="section-header">
                <h2>Popular Templates</h2>
                <p>Start quickly with professionally designed templates</p>
            </div>
            
            <div class="templates-grid">
                <div class="template-card">
                    <div class="template-icon">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                    <h3>E-commerce Store</h3>
                    <p>Complete online store with product catalog, shopping cart, and checkout</p>
                </div>
                
                <div class="template-card">
                    <div class="template-icon">
                        <i class="fas fa-blog"></i>
                    </div>
                    <h3>Blog Website</h3>
                    <p>Modern blog with post management, categories, and reader engagement</p>
                </div>
                
                <div class="template-card">
                    <div class="template-icon">
                        <i class="fas fa-briefcase"></i>
                    </div>
                    <h3>Portfolio</h3>
                    <p>Professional portfolio to showcase your work and attract clients</p>
                </div>
            </div>
            
            <div class="text-center">
                <a href="?page=templates" class="btn btn-primary">
                    <i class="fas fa-eye"></i> View All Templates
                </a>
            </div>
        </div>
    </div>

    <div class="cta">
        <div class="container">
            <div class="cta-content">
                <h2>Ready to Build Your First App?</h2>
                <p>Join thousands of creators who are building amazing applications with AI</p>
                <a href="auth/login.php" class="btn btn-primary btn-lg">
                    <i class="fas fa-rocket"></i> Start Building Now
                </a>
            </div>
        </div>
    </div>
</div>

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
    line-height: 1.6;
    color: #111827;
}

.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
}

/* Hero Section */
.hero {
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
    color: white;
    padding: 6rem 0;
    text-align: center;
}

.hero-content h1 {
    font-size: 4rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
}

.hero-content h1 i {
    margin-right: 1rem;
}

.hero-content p {
    font-size: 1.5rem;
    margin-bottom: 3rem;
    opacity: 0.9;
    max-width: 600px;
    margin-left: auto;
    margin-right: auto;
}

.hero-actions {
    display: flex;
    gap: 2rem;
    justify-content: center;
    flex-wrap: wrap;
}

.btn {
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem 2rem;
    border: none;
    border-radius: 12px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    text-decoration: none;
    font-size: 1.125rem;
}

.btn-lg {
    padding: 1.25rem 2.5rem;
    font-size: 1.25rem;
}

.btn-primary {
    background: white;
    color: #3B82F6;
}

.btn-primary:hover {
    background: #F3F4F6;
    transform: translateY(-2px);
}

.btn-secondary {
    background: rgba(255,255,255,0.2);
    color: white;
    border: 2px solid rgba(255,255,255,0.3);
}

.btn-secondary:hover {
    background: rgba(255,255,255,0.3);
}

/* Features Section */
.features {
    padding: 6rem 0;
    background: #F8FAFC;
}

.section-header {
    text-align: center;
    margin-bottom: 4rem;
}

.section-header h2 {
    font-size: 3rem;
    color: #111827;
    margin-bottom: 1rem;
}

.section-header p {
    font-size: 1.25rem;
    color: #6B7280;
}

.features-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 3rem;
}

.feature-card {
    background: white;
    padding: 3rem 2rem;
    border-radius: 20px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
    text-align: center;
    transition: transform 0.3s;
}

.feature-card:hover {
    transform: translateY(-5px);
}

.feature-icon {
    width: 80px;
    height: 80px;
    background: linear-gradient(135deg, #3B82F6, #1D4ED8);
    border-radius: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 2rem;
    margin: 0 auto 2rem;
}

.feature-card h3 {
    font-size: 1.5rem;
    color: #111827;
    margin-bottom: 1rem;
}

.feature-card p {
    color: #6B7280;
    line-height: 1.6;
}

/* How It Works */
.how-it-works {
    padding: 6rem 0;
}

.steps {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 4rem;
}

.step {
    text-align: center;
    position: relative;
}

.step-number {
    width: 60px;
    height: 60px;
    background: linear-gradient(135deg, #3B82F6, #1D4ED8);
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0 auto 2rem;
}

.step h3 {
    font-size: 1.5rem;
    color: #111827;
    margin-bottom: 1rem;
}

.step p {
    color: #6B7280;
    line-height: 1.6;
}

/* Templates Preview */
.templates-preview {
    padding: 6rem 0;
    background: #F8FAFC;
}

.templates-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 3rem;
    margin-bottom: 3rem;
}

.template-card {
    background: white;
    padding: 2.5rem 2rem;
    border-radius: 16px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.08);
    text-align: center;
    transition: transform 0.3s;
}

.template-card:hover {
    transform: translateY(-3px);
}

.template-icon {
    width: 60px;
    height: 60px;
    background: #EBF8FF;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #3B82F6;
    font-size: 1.5rem;
    margin: 0 auto 1.5rem;
}

.template-card h3 {
    font-size: 1.25rem;
    color: #111827;
    margin-bottom: 1rem;
}

.template-card p {
    color: #6B7280;
    line-height: 1.6;
}

.text-center {
    text-align: center;
}

/* CTA Section */
.cta {
    padding: 6rem 0;
    background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
    color: white;
    text-align: center;
}

.cta-content h2 {
    font-size: 3rem;
    margin-bottom: 1rem;
}

.cta-content p {
    font-size: 1.25rem;
    margin-bottom: 3rem;
    opacity: 0.9;
}

/* Responsive */
@media (max-width: 768px) {
    .hero-content h1 {
        font-size: 2.5rem;
    }
    
    .hero-content p {
        font-size: 1.25rem;
    }
    
    .hero-actions {
        flex-direction: column;
        align-items: center;
    }
    
    .section-header h2 {
        font-size: 2rem;
    }
    
    .features-grid,
    .templates-grid {
        grid-template-columns: 1fr;
    }
    
    .steps {
        grid-template-columns: 1fr;
    }
    
    .cta-content h2 {
        font-size: 2rem;
    }
}
</style>

<?php
// If user is already logged in, redirect to dashboard
if (is_logged_in()) {
    header('Location: ?page=dashboard');
    exit;
}
?>

<?php
include 'includes/footer.php';
?>