<?php
/**
 * Database Configuration
 * Madrasa Management System
 */

class Database {
    private $host;
    private $db_name;
    private $username;
    private $password;
    private $conn;

    public function __construct() {
        // Load configuration from environment or config file
        $this->host = $_ENV['DB_HOST'] ?? 'localhost';
        $this->db_name = $_ENV['DB_NAME'] ?? 'madrasa_management';
        $this->username = $_ENV['DB_USER'] ?? 'root';
        $this->password = $_ENV['DB_PASS'] ?? '';
    }

    public function getConnection() {
        $this->conn = null;
        
        try {
            $this->conn = new PDO(
                "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=utf8mb4",
                $this->username,
                $this->password,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false,
                    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
                ]
            );
        } catch(PDOException $exception) {
            error_log("Connection error: " . $exception->getMessage());
            throw new Exception("Database connection failed");
        }

        return $this->conn;
    }

    public function beginTransaction() {
        return $this->getConnection()->beginTransaction();
    }

    public function commit() {
        return $this->getConnection()->commit();
    }

    public function rollback() {
        return $this->getConnection()->rollBack();
    }
}

/**
 * Environment Configuration
 */
class Config {
    // JWT Configuration
    public static $jwt_secret = $_ENV['JWT_SECRET'] ?? 'your-super-secret-jwt-key-change-this-in-production';
    public static $jwt_algorithm = 'HS256';
    public static $jwt_expiry = 86400 * 7; // 7 days

    // API Configuration
    public static $api_version = 'v1';
    public static $allowed_origins = [
        'http://localhost:3000',
        'https://yourdomain.com',
        'https://www.yourdomain.com'
    ];

    // File Upload Configuration
    public static $upload_path = __DIR__ . '/../uploads/';
    public static $max_file_size = 5 * 1024 * 1024; // 5MB
    public static $allowed_file_types = ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx'];

    // Pagination
    public static $default_page_size = 20;
    public static $max_page_size = 100;

    // Email Configuration
    public static $smtp_host = $_ENV['SMTP_HOST'] ?? 'smtp.gmail.com';
    public static $smtp_port = $_ENV['SMTP_PORT'] ?? 587;
    public static $smtp_username = $_ENV['SMTP_USERNAME'] ?? '';
    public static $smtp_password = $_ENV['SMTP_PASSWORD'] ?? '';

    // Notification Configuration
    public static $enable_sms = $_ENV['ENABLE_SMS'] ?? false;
    public static $twilio_sid = $_ENV['TWILIO_SID'] ?? '';
    public static $twilio_token = $_ENV['TWILIO_TOKEN'] ?? '';
    public static $twilio_phone = $_ENV['TWILIO_PHONE'] ?? '';
}
?>