<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - AI App Generator SaaS</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/auth.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="auth-page">
    <div class="auth-container">
        <div class="auth-card">
            <div class="auth-header">
                <div class="auth-logo">
                    <i class="fas fa-magic"></i>
                    <span>AI App Generator</span>
                </div>
                <h1>Welcome Back</h1>
                <p>Sign in to your account to continue building amazing applications</p>
            </div>
            
            <?php if (isset($error)): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-triangle"></i>
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>
            
            <form method="post" id="loginForm" class="auth-form">
                <div class="form-group">
                    <label for="email">Email Address</label>
                    <div class="input-group">
                        <i class="fas fa-envelope input-icon"></i>
                        <input type="email" id="email" name="email" required 
                               placeholder="Enter your email" 
                               value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
                    </div>
                    <div class="error-message" id="emailError"></div>
                </div>
                
                <div class="form-group">
                    <label for="password">Password</label>
                    <div class="input-group">
                        <i class="fas fa-lock input-icon"></i>
                        <input type="password" id="password" name="password" required 
                               placeholder="Enter your password">
                        <button type="button" class="password-toggle" onclick="togglePassword('password')">
                            <i class="fas fa-eye"></i>
                        </button>
                    </div>
                    <div class="error-message" id="passwordError"></div>
                </div>
                
                <div class="form-options">
                    <label class="checkbox-label">
                        <input type="checkbox" name="remember" value="1">
                        <span class="checkbox-custom"></span>
                        Remember me
                    </label>
                    <a href="?page=forgot-password" class="forgot-link">Forgot password?</a>
                </div>
                
                <button type="submit" class="btn-auth" id="loginBtn">
                    <i class="fas fa-sign-in-alt"></i>
                    Sign In
                </button>
            </form>
            
            <div class="auth-footer">
                <p>Don't have an account? 
                    <a href="?page=register" class="auth-link">Sign up for free</a>
                </p>
            </div>
            
            <div class="auth-divider">
                <span>or</span>
            </div>
            
            <div class="social-login">
                <button class="btn-social btn-google" type="button">
                    <i class="fab fa-google"></i>
                    Continue with Google
                </button>
                <button class="btn-social btn-github" type="button">
                    <i class="fab fa-github"></i>
                    Continue with GitHub
                </button>
            </div>
            
            <div class="back-home">
                <a href="?page=home">
                    <i class="fas fa-arrow-left"></i>
                    Back to Home
                </a>
            </div>
        </div>
        
        <div class="auth-visual">
            <div class="auth-illustration">
                <div class="illustration-element element-1">
                    <i class="fas fa-code"></i>
                </div>
                <div class="illustration-element element-2">
                    <i class="fas fa-robot"></i>
                </div>
                <div class="illustration-element element-3">
                    <i class="fas fa-mobile-alt"></i>
                </div>
                <div class="illustration-element element-4">
                    <i class="fas fa-cloud"></i>
                </div>
                <div class="floating-text">
                    <h2>Build Applications</h2>
                    <p>With AI Power</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="auth-background">
        <div class="bg-shapes">
            <div class="shape shape-1"></div>
            <div class="shape shape-2"></div>
            <div class="shape shape-3"></div>
            <div class="shape shape-4"></div>
        </div>
    </div>
    
    <script>
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            const icon = field.parentNode.querySelector('.password-toggle i');
            
            if (field.type === 'password') {
                field.type = 'text';
                icon.className = 'fas fa-eye-slash';
            } else {
                field.type = 'password';
                icon.className = 'fas fa-eye';
            }
        }
        
        // Form validation
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const email = document.getElementById('email').value;
            const password = document.getElementById('password').value;
            
            // Clear previous errors
            document.getElementById('emailError').textContent = '';
            document.getElementById('passwordError').textContent = '';
            
            let isValid = true;
            
            // Email validation
            if (!email) {
                document.getElementById('emailError').textContent = 'Email is required';
                isValid = false;
            } else if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
                document.getElementById('emailError').textContent = 'Please enter a valid email';
                isValid = false;
            }
            
            // Password validation
            if (!password) {
                document.getElementById('passwordError').textContent = 'Password is required';
                isValid = false;
            }
            
            if (!isValid) {
                e.preventDefault();
            } else {
                // Show loading state
                const btn = document.getElementById('loginBtn');
                btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Signing In...';
                btn.disabled = true;
            }
        });
        
        // Auto-focus first field
        document.getElementById('email').focus();
    </script>
</body>
</html>