<?php
/**
 * SaaS AI Application Generator Configuration
 * 
 * Author: MiniMax Agent
 * Date: 2025-11-07
 */

// Site Configuration
define('SITE_NAME', 'AI App Generator SaaS');
define('SITE_URL', 'https://yourdomain.com/saas-ai-generator');
define('SITE_ADMIN_EMAIL', 'admin@yourdomain.com');
define('SITE_DESCRIPTION', 'AI-Powered Application Generator for Businesses');

// Business Configuration
define('COMPANY_NAME', 'AI Solutions Ltd.');
define('SUPPORT_EMAIL', 'support@yourdomain.com');
define('BILLING_EMAIL', 'billing@yourdomain.com');

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'cpanel_username_saas_ai_generator');
define('DB_USER', 'cpanel_username_saas_user');
define('DB_PASS', 'your_database_password');
define('DB_CHARSET', 'utf8mb4');

// AI Providers Configuration
define('OPENAI_API_KEY', 'your_openai_api_key');
define('CLAUDE_API_KEY', 'your_claude_api_key');
define('GEMINI_API_KEY', 'your_gemini_api_key');
define('CUSTOM_AI_ENDPOINT', 'your_custom_ai_endpoint');
define('CUSTOM_AI_API_KEY', 'your_custom_ai_key');

// Payment Configuration
define('STRIPE_PUBLISHABLE_KEY', 'pk_test_your_stripe_key');
define('STRIPE_SECRET_KEY', 'sk_test_your_stripe_secret');
define('STRIPE_WEBHOOK_SECRET', 'whsec_your_webhook_secret');

// Email Configuration
define('SMTP_HOST', 'smtp.yourdomain.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'noreply@yourdomain.com');
define('SMTP_PASSWORD', 'your_smtp_password');
define('SMTP_ENCRYPTION', 'tls');

// Security Configuration
define('SECRET_KEY', 'your_super_secret_key_here_32_characters_long');
define('JWT_SECRET', 'your_jwt_secret_key_here');
define('CSRF_TOKEN_NAME', 'csrf_token');
define('PASSWORD_MIN_LENGTH', 8);
define('SESSION_TIMEOUT', 7200); // 2 hours

// File Upload Configuration
define('UPLOAD_MAX_SIZE', 50 * 1024 * 1024); // 50MB
define('UPLOAD_PATH', 'uploads/');
define('EXPORT_PATH', 'exports/');
define('TEMPLATE_PATH', 'templates/');

// Application Configuration
define('APP_VERSION', '1.0.0');
define('APP_ENV', 'production'); // development, production
define('APP_DEBUG', false);
define('APP_LOCALE', 'en');
define('APP_TIMEZONE', 'Asia/Karachi');

// Subscription Plans
define('PLANS', [
    'free' => [
        'name' => 'Free',
        'price' => 0,
        'currency' => 'USD',
        'interval' => 'month',
        'features' => [
            'projects' => 3,
            'ai_generations' => 10,
            'export_formats' => ['zip'],
            'support' => 'community',
            'branding' => 'ai-app-generator'
        ],
        'limits' => [
            'projects_per_month' => 3,
            'ai_calls_per_month' => 10,
            'storage_mb' => 100
        ]
    ],
    'basic' => [
        'name' => 'Basic',
        'price' => 9,
        'currency' => 'USD',
        'interval' => 'month',
        'features' => [
            'projects' => 50,
            'ai_generations' => 500,
            'export_formats' => ['zip', 'github'],
            'support' => 'email',
            'branding' => 'remove'
        ],
        'limits' => [
            'projects_per_month' => 50,
            'ai_calls_per_month' => 500,
            'storage_mb' => 1000
        ],
        'popular' => false
    ],
    'pro' => [
        'name' => 'Pro',
        'price' => 29,
        'currency' => 'USD',
        'interval' => 'month',
        'features' => [
            'projects' => 500,
            'ai_generations' => 5000,
            'export_formats' => ['zip', 'github', 'ftp', 'deploy'],
            'support' => 'priority',
            'branding' => 'remove',
            'custom_domains' => true,
            'api_access' => true
        ],
        'limits' => [
            'projects_per_month' => 500,
            'ai_calls_per_month' => 5000,
            'storage_mb' => 10000
        ],
        'popular' => true
    ],
    'enterprise' => [
        'name' => 'Enterprise',
        'price' => 99,
        'currency' => 'USD',
        'interval' => 'month',
        'features' => [
            'projects' => -1, // unlimited
            'ai_generations' => -1, // unlimited
            'export_formats' => ['zip', 'github', 'ftp', 'deploy', 'custom'],
            'support' => 'dedicated',
            'branding' => 'remove',
            'custom_domains' => true,
            'api_access' => true,
            'white_label' => true,
            'custom_integrations' => true
        ],
        'limits' => [
            'projects_per_month' => -1, // unlimited
            'ai_calls_per_month' => -1, // unlimited
            'storage_mb' => 100000
        ],
        'popular' => false
    ]
]);

// AI Generation Configuration
define('AI_PROVIDERS', [
    'openai' => [
        'name' => 'OpenAI GPT',
        'api_endpoint' => 'https://api.openai.com/v1/chat/completions',
        'model' => 'gpt-4',
        'max_tokens' => 4000,
        'temperature' => 0.7
    ],
    'claude' => [
        'name' => 'Anthropic Claude',
        'api_endpoint' => 'https://api.anthropic.com/v1/messages',
        'model' => 'claude-3-sonnet-20240229',
        'max_tokens' => 4000,
        'temperature' => 0.7
    ],
    'gemini' => [
        'name' => 'Google Gemini',
        'api_endpoint' => 'https://generativelanguage.googleapis.com/v1beta/models/gemini-pro:generateContent',
        'model' => 'gemini-pro',
        'max_tokens' => 4000,
        'temperature' => 0.7
    ]
]);

// Email Templates
define('EMAIL_TEMPLATES', [
    'welcome' => [
        'subject' => 'Welcome to AI App Generator SaaS!',
        'template' => 'welcome_email.html'
    ],
    'reset_password' => [
        'subject' => 'Reset Your Password',
        'template' => 'reset_password.html'
    ],
    'subscription_created' => [
        'subject' => 'Subscription Activated',
        'template' => 'subscription_created.html'
    ],
    'subscription_cancelled' => [
        'subject' => 'Subscription Cancelled',
        'template' => 'subscription_cancelled.html'
    ],
    'project_completed' => [
        'subject' => 'Your AI Application is Ready!',
        'template' => 'project_completed.html'
    ]
]);

// Social Media & Marketing
define('SOCIAL_LINKS', [
    'twitter' => 'https://twitter.com/your_handle',
    'linkedin' => 'https://linkedin.com/company/your_company',
    'github' => 'https://github.com/your_github',
    'facebook' => 'https://facebook.com/your_page'
]);

// Analytics & Tracking
define('GOOGLE_ANALYTICS_ID', 'GA-XXXXXXXXX');
define('GOOGLE_TAG_MANAGER_ID', 'GTM-XXXXXXX');
define('FACEBOOK_PIXEL_ID', 'XXXXXXXXX');

// Development & Debug Settings
if (APP_ENV === 'development') {
    define('APP_DEBUG', true);
    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ALL);
} else {
    define('APP_DEBUG', false);
    ini_set('display_errors', 0);
    error_reporting(0);
}

// Security Headers
header('X-Content-Type-Options: nosniff');
header('X-Frame-Options: DENY');
header('X-XSS-Protection: 1; mode=block');
header('Referrer-Policy: strict-origin-when-cross-origin');

// Set default timezone
date_default_timezone_set(APP_TIMEZONE);
?>