<?php
/**
 * AI Application Generator SaaS Platform
 * Complete Business Solution
 * 
 * Author: MiniMax Agent
 * Version: 1.0.0
 * Date: 2025-11-07
 */

// Start session
session_start();

// Include configuration
require_once 'config/config.php';
require_once 'includes/functions.php';
require_once 'includes/database.php';

// Router
$page = $_GET['page'] ?? 'home';

// Check if installation is completed
if (!file_exists('config/installed.lock') && $page !== 'install') {
    header('Location: install/');
    exit();
}

// Handle routes
switch ($page) {
    case 'home':
        require_once 'pages/landing.php';
        break;
        
    case 'dashboard':
        require_auth();
        require_once 'pages/dashboard.php';
        break;
        
    case 'generator':
        require_auth();
        require_once 'pages/generator.php';
        break;
        
    case 'projects':
        require_auth();
        require_once 'pages/projects.php';
        break;
        
    case 'templates':
        require_once 'pages/templates.php';
        break;
        
    case 'pricing':
        require_once 'pages/pricing.php';
        break;
        
    case 'login':
        if (is_logged_in()) {
            header('Location: ?page=dashboard');
            exit();
        }
        require_once 'auth/login.php';
        break;
        
    case 'register':
        if (is_logged_in()) {
            header('Location: ?page=dashboard');
            exit();
        }
        require_once 'auth/register.php';
        break;
        
    case 'logout':
        logout();
        header('Location: ?page=home');
        exit();
        break;
        
    case 'subscription':
        require_auth();
        require_once 'pages/subscription.php';
        break;
        
    case 'admin':
        require_auth();
        require_once 'admin/dashboard.php';
        break;
        
    case 'api':
        header('Content-Type: application/json');
        require_once 'api/index.php';
        break;
        
    default:
        require_once 'pages/landing.php';
        break;
}

// Include global header and footer
if (in_array($page, ['home', 'pricing', 'templates']) || (in_array($page, ['dashboard', 'generator', 'projects', 'subscription', 'admin']) && is_logged_in())) {
    include 'includes/header.php';
    include 'includes/footer.php';
}
?>