<?php
/**
 * User Dashboard
 * SaaS AI Application Generator
 * 
 * Author: MiniMax Agent
 * Date: 2025-11-07
 */

$user = getCurrentUser();
if (!$user) {
    header('Location: ?page=login');
    exit();
}

// Get user's plan details
$plan = getUserPlan($user['id']);

// Get recent projects
$recentProjects = $db->fetchAll("SELECT * FROM projects WHERE user_id = ? ORDER BY created_at DESC LIMIT 6", [$user['id']]);

// Get usage statistics
$currentMonth = date('Y-m');
$projectsThisMonth = $db->count('projects', 'user_id = ? AND DATE_FORMAT(created_at, "%Y-%m") = ?', [$user['id'], $currentMonth]);
$aiGenerationsThisMonth = $db->count('ai_generations', 'user_id = ? AND DATE_FORMAT(created_at, "%Y-%m") = ?', [$user['id'], $currentMonth]);

// Get system stats
$totalUsers = $db->count('users', 'status = "active"');
$totalProjects = $db->count('projects', 'status = "active"');
$totalGenerations = $db->count('ai_generations', 'status = "completed"');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/dashboard.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="dashboard-page">
    <!-- Sidebar -->
    <aside class="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <i class="fas fa-magic"></i>
                <span>AI App Generator</span>
            </div>
        </div>
        
        <nav class="sidebar-nav">
            <div class="nav-section">
                <div class="nav-section-title">Main</div>
                <a href="?page=dashboard" class="nav-link active">
                    <i class="fas fa-home"></i>
                    Dashboard
                </a>
                <a href="?page=generator" class="nav-link">
                    <i class="fas fa-robot"></i>
                    AI Generator
                </a>
                <a href="?page=projects" class="nav-link">
                    <i class="fas fa-folder"></i>
                    My Projects
                </a>
                <a href="?page=templates" class="nav-link">
                    <i class="fas fa-layer-group"></i>
                    Templates
                </a>
            </div>
            
            <div class="nav-section">
                <div class="nav-section-title">Account</div>
                <a href="?page=subscription" class="nav-link">
                    <i class="fas fa-credit-card"></i>
                    Subscription
                </a>
                <a href="#" class="nav-link">
                    <i class="fas fa-cog"></i>
                    Settings
                </a>
                <a href="#" class="nav-link">
                    <i class="fas fa-question-circle"></i>
                    Help & Support
                </a>
            </div>
            
            <?php if ($user['role'] === 'admin'): ?>
            <div class="nav-section">
                <div class="nav-section-title">Admin</div>
                <a href="?page=admin" class="nav-link">
                    <i class="fas fa-shield-alt"></i>
                    Admin Panel
                </a>
            </div>
            <?php endif; ?>
        </nav>
        
        <div class="sidebar-footer">
            <div class="user-info">
                <div class="user-avatar">
                    <?= strtoupper(substr($user['name'], 0, 2)) ?>
                </div>
                <div class="user-details">
                    <div class="user-name"><?= htmlspecialchars($user['name']) ?></div>
                    <div class="user-plan"><?= ucfirst($plan['name']) ?> Plan</div>
                </div>
            </div>
            <a href="?page=logout" class="logout-btn">
                <i class="fas fa-sign-out-alt"></i>
            </a>
        </div>
    </aside>
    
    <!-- Main Content -->
    <main class="main-content">
        <div class="top-bar">
            <div class="top-bar-left">
                <h1>Welcome back, <?= htmlspecialchars($user['name']) ?>!</h1>
                <p>Let's build something amazing today</p>
            </div>
            <div class="top-bar-right">
                <button class="btn-quick-action" onclick="location.href='?page=generator'">
                    <i class="fas fa-plus"></i>
                    New Project
                </button>
            </div>
        </div>
        
        <!-- Stats Cards -->
        <div class="stats-grid">
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-folder"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-number"><?= count($recentProjects) ?></div>
                    <div class="stat-label">Total Projects</div>
                    <div class="stat-change positive">
                        <i class="fas fa-arrow-up"></i>
                        +<?= $projectsThisMonth ?> this month
                    </div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-robot"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-number"><?= $aiGenerationsThisMonth ?></div>
                    <div class="stat-label">AI Generations</div>
                    <div class="stat-change neutral">
                        <i class="fas fa-chart-line"></i>
                        <?= $plan['limits']['ai_calls_per_month'] === -1 ? 'Unlimited' : 'Limit: ' . $plan['limits']['ai_calls_per_month'] ?>
                    </div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-star"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-number"><?= ucfirst($plan['name']) ?></div>
                    <div class="stat-label">Current Plan</div>
                    <div class="stat-change">
                        <a href="?page=subscription" class="upgrade-link">
                            <i class="fas fa-arrow-up"></i>
                            Upgrade
                        </a>
                    </div>
                </div>
            </div>
            
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="stat-content">
                    <div class="stat-number"><?= timeAgo($user['created_at']) ?></div>
                    <div class="stat-label">Member Since</div>
                    <div class="stat-change neutral">
                        <i class="fas fa-calendar"></i>
                        <?= date('M j, Y', strtotime($user['created_at'])) ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Quick Actions -->
        <div class="quick-actions">
            <h2>Quick Actions</h2>
            <div class="actions-grid">
                <div class="action-card" onclick="location.href='?page=generator'">
                    <div class="action-icon">
                        <i class="fas fa-magic"></i>
                    </div>
                    <h3>Generate App</h3>
                    <p>Create a new application with AI</p>
                </div>
                
                <div class="action-card" onclick="location.href='?page=templates'">
                    <div class="action-icon">
                        <i class="fas fa-layer-group"></i>
                    </div>
                    <h3>Browse Templates</h3>
                    <p>Start with pre-built templates</p>
                </div>
                
                <div class="action-card" onclick="location.href='?page=projects'">
                    <div class="action-icon">
                        <i class="fas fa-folder-open"></i>
                    </div>
                    <h3>Manage Projects</h3>
                    <p>View and edit your projects</p>
                </div>
                
                <div class="action-card" onclick="location.href='?page=subscription'">
                    <div class="action-icon">
                        <i class="fas fa-crown"></i>
                    </div>
                    <h3>Upgrade Plan</h3>
                    <p>Unlock more features and limits</p>
                </div>
            </div>
        </div>
        
        <!-- Recent Projects -->
        <div class="recent-projects">
            <div class="section-header">
                <h2>Recent Projects</h2>
                <a href="?page=projects" class="view-all">View All</a>
            </div>
            
            <?php if (empty($recentProjects)): ?>
                <div class="empty-state">
                    <i class="fas fa-folder-open"></i>
                    <h3>No projects yet</h3>
                    <p>Create your first AI-generated application to get started</p>
                    <a href="?page=generator" class="btn-primary">Start Building</a>
                </div>
            <?php else: ?>
                <div class="projects-grid">
                    <?php foreach ($recentProjects as $project): ?>
                        <div class="project-card">
                            <div class="project-header">
                                <div class="project-type">
                                    <i class="fas fa-code"></i>
                                </div>
                                <div class="project-status status-<?= $project['status'] ?>">
                                    <?= ucfirst($project['status']) ?>
                                </div>
                            </div>
                            <h3 class="project-title"><?= htmlspecialchars($project['name']) ?></h3>
                            <p class="project-description"><?= htmlspecialchars($project['description']) ?></p>
                            <div class="project-meta">
                                <div class="project-tech">
                                    <i class="fas fa-cog"></i>
                                    <?= htmlspecialchars($project['tech_stack']) ?>
                                </div>
                                <div class="project-date">
                                    <?= timeAgo($project['created_at']) ?>
                                </div>
                            </div>
                            <div class="project-actions">
                                <button class="btn-sm btn-primary" onclick="viewProject(<?= $project['id'] ?>)">
                                    View
                                </button>
                                <button class="btn-sm btn-secondary" onclick="exportProject(<?= $project['id'] ?>)">
                                    Export
                                </button>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Platform Stats -->
        <div class="platform-stats">
            <div class="section-header">
                <h2>Platform Statistics</h2>
            </div>
            <div class="platform-grid">
                <div class="platform-stat">
                    <div class="platform-number"><?= number_format($totalUsers) ?></div>
                    <div class="platform-label">Active Users</div>
                </div>
                <div class="platform-stat">
                    <div class="platform-number"><?= number_format($totalProjects) ?></div>
                    <div class="platform-label">Projects Generated</div>
                </div>
                <div class="platform-stat">
                    <div class="platform-number"><?= number_format($totalGenerations) ?></div>
                    <div class="platform-label">AI Generations</div>
                </div>
                <div class="platform-stat">
                    <div class="platform-number">99.9%</div>
                    <div class="platform-label">Uptime</div>
                </div>
            </div>
        </div>
    </main>
    
    <script>
        function viewProject(projectId) {
            // Implement project viewing
            location.href = `?page=projects&view=${projectId}`;
        }
        
        function exportProject(projectId) {
            // Implement project export
            window.open(`?page=api&action=export&id=${projectId}`, '_blank');
        }
        
        // Initialize dashboard
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Dashboard initialized');
            
            // Update stats every 30 seconds
            setInterval(updateStats, 30000);
        });
        
        function updateStats() {
            // Implement real-time stats update via AJAX
            fetch('?page=api&action=stats')
                .then(response => response.json())
                .then(data => {
                    // Update stats display
                    console.log('Stats updated:', data);
                })
                .catch(error => {
                    console.error('Error updating stats:', error);
                });
        }
    </script>
</body>
</html>